/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.widgets;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.Set;
import technology.rocketjump.undermount.assets.TextureAtlasRepository;
import technology.rocketjump.undermount.rendering.HexColors;
import technology.rocketjump.undermount.ui.fonts.FontRepository;
import technology.rocketjump.undermount.ui.fonts.GameFont;
import technology.rocketjump.undermount.ui.i18n.I18nTranslator;
import technology.rocketjump.undermount.ui.i18n.I18nUpdatable;
import technology.rocketjump.undermount.ui.widgets.ButtonStyle;
import technology.rocketjump.undermount.ui.widgets.IconButton;

@Singleton
public class IconButtonFactory
implements I18nUpdatable,
Telegraph {
    private final I18nTranslator translator;
    private final TextureAtlas textureAtlas;
    private final NinePatch buttonNinePatch;
    private final GameFont defaultFont;
    private final Color backgroundColor = HexColors.get("#545E61");
    private final Set<IconButton> allInstances = new HashSet<IconButton>();

    @Inject
    public IconButtonFactory(I18nTranslator translator, FontRepository fontRepository, TextureAtlasRepository textureAtlasRepository, MessageDispatcher messageDispatcher) {
        this.translator = translator;
        this.textureAtlas = textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.GUI_TEXTURE_ATLAS);
        this.buttonNinePatch = this.textureAtlas.createPatch("button");
        this.defaultFont = fontRepository.getDefaultFontForUI();
        messageDispatcher.addListener(this, 291);
    }

    public IconButton create(String i18nLabelKey, String iconName, Color buttonColor, ButtonStyle style) {
        IconButton iconButton = new IconButton(this.defaultFont, i18nLabelKey, style);
        iconButton.setLabelText(this.translator.getTranslatedString(i18nLabelKey));
        iconButton.setBackgroundColor(this.backgroundColor);
        iconButton.setForegroundColor(buttonColor);
        if (iconName != null) {
            iconButton.setIconSprite(this.textureAtlas.createSprite(iconName));
        }
        iconButton.setButtonNinepatch(this.buttonNinePatch);
        this.allInstances.add(iconButton);
        return iconButton;
    }

    @Override
    public void onLanguageUpdated() {
        for (IconButton button : this.allInstances) {
            button.setLabelText(this.translator.getTranslatedString(button.getI18nKey()));
        }
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 291: {
                this.onLanguageUpdated();
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }
}

